import openmatrix as omx
import numpy as np
import openpyxl

#Apertura del file OMX di input
OMXfileI = omx.open_file('IMQ2013_zonecampionarie.omx')
print("File OMX di riferimento: ",OMXfileI.filename,'\n')
#Apertura del file OMX di output
OMXfileO = omx.open_file('IMQ2013_sceltamezzopubblico.omx','w')
#Apretura del file di scrittura dei risultati
filex100 = open("SceltaMezzoPubblico.txt","w")
filex100.write('COD_ZONA;UTILIZZOx100;coord_X;coord_Y\n')

#Caricamento delle informazioni sulla mappatura
excel_document = openpyxl.load_workbook('ZoneCampionarie2013.xlsx') 
nsheet = excel_document.sheetnames  
sheet = excel_document[nsheet[0]] 
zoneA = list()   
zoneN = np.zeros(209)
for j in range(0,209):
    zoneA.append(sheet.cell(row=j+2,column=2).value)
    zoneN[j] = sheet.cell(row=j+2,column=1).value    
    
#Estrazione delle matrici
for pop in ['TO','PIE']:
    for per in ['IG','OP']:
        for sco in ['sr','t']:
            if not (sco=='sr' and per=='OP'):
                NEWmatr = np.zeros((209,209))
                for i in range(0,209):
                    for j in range(0,209):
                        if not OMXfileI['Res'+pop+'mPu'+per+sco][i][j]+OMXfileI['Res'+pop+'mPr'+per+sco][i][j] == 0:
                            NEWmatr[i][j] = OMXfileI['Res'+pop+'mPu'+per+sco][i][j]/(OMXfileI['Res'+pop+'mPu'+per+sco][i][j]+OMXfileI['Res'+pop+'mPr'+per+sco][i][j])*100
                OMXfileO['Res'+pop+'x100mPu'+per+sco] = NEWmatr        
                #Scrittura dei metadati complementari
                OMXfileO['Res'+pop+'x100mPu'+per+sco].attrs.Indagine = 'IMQ 2013'
                OMXfileO['Res'+pop+'x100mPu'+per+sco].attrs.Modo = '% di utilizzo del mezzo pubblico'
                if pop=='TO':
                    OMXfileO['Res'+pop+'x100mPu'+per+sco].attrs.Popolazione = 'Provincia di Torino'
                    OMXfileO['Res'+pop+'x100mPu'+per+sco].attrs.NumCampione = 32460
                else:
                    OMXfileO['Res'+pop+'x100mPu'+per+sco].attrs.Popolazione = 'Regione Piemonte'
                    OMXfileO['Res'+pop+'x100mPu'+per+sco].attrs.NumCampione = 52119
                if per=='IG':
                    OMXfileO['Res'+pop+'x100mPu'+per+sco].attrs.Periodo = 'Intera giornata'
                else:
                    OMXfileO['Res'+pop+'x100mPu'+per+sco].attrs.Periodo = 'Ora di punta (arrivo 07:43-08:42)'
                if sco=='sr':
                    OMXfileO['Res'+pop+'x100mPu'+per+sco].attrs.Scopo = 'Tutti escluso ritorno'
                else:
                    OMXfileO['Res'+pop+'x100mPu'+per+sco].attrs.Scopo = 'Tutti'                       

#Associazione della mappatura dell'indice
OMXfileO.create_mapping('Mappatura',zoneN) 
print("FILE OMX CREATO:  IMQ2013_sceltamezzopubblico.omx")

#Scrittura dati su file di testo
for i in range(0,209):
    FProdPU = 0
    FProdPR = 0
    for j in range(0,209):
        FProdPU = FProdPU + OMXfileI['ResPIEmPuOPt'][i][j]
        FProdPR = FProdPR + OMXfileI['ResPIEmPrOPt'][i][j]
    PERC = str(FProdPU/(FProdPU+FProdPR)*100)
    cod = sheet.cell(row=i+2,column=2).value
    cX = str(sheet.cell(row=i+2,column=7).value)
    cY = str(sheet.cell(row=i+2,column=8).value)
    filex100.write((cod+';'+PERC+';'+cX+';'+cY)); filex100.write('\n')
print("FILE TXT CREATO:  SceltaMezzoPubblico.txt")

#Chiusura dei file aperti
OMXfileI.close()
OMXfileO.close()
filex100.close()
